/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobSawmill;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingSawmill
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    private static final String SAWMILL = "sawmill";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingSawmill(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SAWMILL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobSawmill(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SAWMILL;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.sawmill;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobSawmill(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingSawmill.SAWMILL);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            double amountOfValidBlocks = 0.0;
            double blocks = 0.0;
            for (List<ItemStack> stacks : recipe.getInputs()) {
                ItemStack stack;
                if (stacks.isEmpty() || ItemStackUtils.isEmpty(stack = stacks.get(0)).booleanValue()) continue;
                if (stack.func_77973_b().func_206844_a((ITag)ItemTags.field_199905_b) || stack.func_77973_b().func_206844_a((ITag)ItemTags.field_200038_h)) {
                    amountOfValidBlocks += (double)stack.func_190916_E();
                    continue;
                }
                for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                    if (!tag.func_110623_a().contains("wood")) continue;
                    amountOfValidBlocks += (double)stack.func_190916_E();
                    break;
                }
                blocks += (double)stack.func_190916_E();
            }
            return amountOfValidBlocks > 0.0 && amountOfValidBlocks / blocks > 0.75;
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingSawmill.SAWMILL);
        }
    }
}

